%% This weight scheme will be used by consensus algorithms where W 1 = 0.
% % scheme zero: when W 1 = 0
% % scheme one: when W 1 = 1
function ret = Metropolis( A,scheme)
%% Metropolis Weight
%networkSize is # of nodes
%adjacency \matrix of network dimension should be equal by networkSize
%L Upperbound of Hessian Matrix of cost function.
% for metropolis weight which is assigned in a distributed manner we should
% know at least maximum value of hessian matrix (second derivative) of goal
% function locally. 
% % % % % Metropolis For resource allocation app is wrong
epsilon= .01;
switch scheme
    case {'zero'}
          [m,n] = size(A);
         if (trace(A)>0)
             A = A-eye(n,m);
         end;
        
        metroPolisW = zeros(m,n);
        for i=1:m
            sum=0;
            for j=1:n
                 if A(i,j)~=0 && i~=j
% %                      based on Xiao-boyd cf (B.johanson thesis P.27),
% epsilon is sufficiently small positive constant
                     metroPolisW(i,j)=-min(1/nnz(A(i,:)) , 1/nnz(A(j,:)))+epsilon;
                    sum=sum+ metroPolisW(i,j);
                 end        
            end
         metroPolisW(i,i)=-sum;
        end
        ret = metroPolisW;
   
    case {'one'}
%         check if the main diagonal elements are one set zero for them
           [n,m] = size(A);
         if (trace(A)>0)
             A = A-eye(n,m);
         end;
        
        w = zeros(n,m);
        for i=1:n
        sum=0;
            for j=1:m
                 if A(i,j)~=0 && i~=j
                w(i,j)=1/(1+max(nnz(A(i,:)),nnz(A(j,:))));
                sum=sum+w(i,j);
                 end        
            end
        w(i,i)=1-sum;
        end
        ret = w;
        
% bjorn formulation
%         for i=1:n
%         sum=0;
%             for j=1:m
%                  if A(i,j)~=0 && i~=j
%                 w(i,j)= min (1/nnz(A(i,:)), 1/nnz(A(j,:)));
%                 sum=sum+max(0, 1/nnz(A(i,:))- 1/nnz(A(j,:)));
%                  end        
%             end
%         w(i,i)=sum;
%         end   
%         ret = w;
        
end