%give an orthonormal matrix of size n*m.
function Q = GramShmidt(A)
[m,n]= size(A); Q = zeros(m,n); R = zeros(n,n);
for j= 1:n,
    v = A(:,j); %begin with column j of A
    for i=1:j-1
        R(i,j)=Q(:,i)'*A(:,j); 
        v= v - R(i,j)*Q(:,i);
    end,
    R(j,j)= norm(v);
    Q(:,j) = v/R(j,j);
end,
