function [W, rate]= BoydOptimalWeight(A,L,U)

% % % % A : adjacency matrix
% % % % % % H: Hessian at the optimal point


% % % Add path
% root = 'C:\Program Files\MATLAB\R2010b\Yalmip';
% addpath(strcat((root),'\yalmip'));
% addpath(strcat((root),'\yalmip\extras'));
% addpath(strcat((root),'\yalmip\demos'));
% addpath(strcat((root),'\yalmip\solvers'));
% addpath(strcat((root),'\yalmip\modules'));
% addpath(strcat((root),'\yalmip\modules\parametric'));
% addpath(strcat((root),'\yalmip\modules\moment'));
% addpath(strcat((root),'\yalmip\modules\global'));
% addpath(strcat((root),'\yalmip\modules\sos'));
% addpath(strcat((root),'\yalmip\operators'));

% % % % 
% % % SEDUMI 
% % % 
% root_sedumi = 'C:\Program Files\MATLAB\R2010b\seDumi';
% addpath(strcat((root_sedumi),'\SeDuMi_1_3'));


netSize = size(A,1);
% 

% % here we make sure that A has diagonal 1 element
A= max(A,eye(netSize,netSize));



% defining the variables
 s = sdpvar (1,1);

Q = sdpvar(netSize,netSize);
% define Q (laplacian type) as a positive semidefinite(stmmetric) and Q1=0; also impose sparsity patterns for given network 


F =  [ s>= 0];
%sparsity pattern

for i=1:netSize,
    for j=i:netSize,
        if A(i,j)==0
            F = F + set(Q(i,j)==0)+ set(Q(j,i)==0);
        end;
    end;
end;
%
% F = F + [Q==Laplacian];
F = F+ [Q >= 0] + [Q*ones(netSize,1) == zeros(netSize,1)];
% constrain corresponds to maximum eigenvale
%  F = F+[ Q <= eye(netSize)];
Lmii = [Q+Q'+(1/netSize)*ones(netSize,1)*ones(netSize,1)'-s*(L^(-1)-1/(ones(netSize,1)'*L^(-1)*ones(netSize,1))*L^(-1)*ones(netSize,1)*ones(netSize,1)'*L^(-1)), Q' ; Q, U^(-1)];
F = F+[Lmii >= 0];
%  diagnostics = solvesdp(F,t);
diagnostics = solvesdp(F, -s);
W = double(Q);
rate = double(s);


